package jamezo97.clonecraft.entity.clone;

import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.Reflect;

import java.util.ArrayList;
import java.util.HashMap;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

import org.apache.commons.lang3.ArrayUtils;

public class CloneOptions {
	
	private HashMap<Integer, CloneOption> idToOption = new HashMap<Integer, CloneOption>();
	
	private ArrayList<CloneOption> options = new ArrayList<CloneOption>();
	
	ArrayList<Integer> entitiesToAttack = new ArrayList<Integer>();
	
	boolean entitiesUpToDate = false;
	
	int[] allEntities;
	
	public boolean shouldAttack(int entityType){
		return entitiesToAttack.contains(entityType);
	}
	
	public boolean shouldAttack(Entity e){
		if(e != null){
			return shouldAttack(EntityList.getEntityID(e));
		}
		return false;
	}
	

	public boolean shouldAttack(EntityAttackEntry entry){
		return shouldAttack(entry.entityId);
	}
	
	public boolean removeEntityToAttack(EntityAttackEntry entry){
		return removeEntityToAttack(entry.entityId);
	}
	
	public boolean removeEntityToAttack(int entityId){
		if(entitiesToAttack.contains(entityId)){
			entitiesUpToDate = false;
			return entitiesToAttack.remove((Integer)entityId);
		}
		return false;
	}
	
	public boolean addEntityToAttack(int entityId){
		if(!entitiesToAttack.contains(entityId)){
			entitiesUpToDate = false;
			return entitiesToAttack.add(entityId);
		}
		return false;
	}
	
	public boolean addEntityToAttack(EntityAttackEntry entry) {
		return addEntityToAttack(entry.entityId);
	}
	
	
	public int classToId(Class c){
		if(classToIDMapping != null){
			Object o = (Integer)classToIDMapping.get(c);
			if(o != null && o instanceof Integer){
				return (Integer)o;
			}
			
		}
		return -1;
	}
	
	public void addEntitiesToAttack(int[] values) {
		if(values != null){
			for(int a = 0; a < values.length; a++){
				addEntityToAttack(values[a]);
			}
		}
	}
	
	public void removeEntitiesToAttack(int[] values) {
		if(values != null){
			for(int a = 0; a < values.length; a++){
				removeEntityToAttack(values[a]);
			}
		}
	}

	public int[] getAllEntities(){
		if(!entitiesUpToDate){
			entitiesUpToDate = true;
			allEntities = ArrayUtils.toPrimitive(entitiesToAttack.toArray(new Integer[entitiesToAttack.size()]));
		}
		return allEntities;
	}
	
	public void clearEntitiesToAttack() {
		entitiesToAttack.clear();
		entitiesUpToDate = false;
	}
	
	
	
	public ArrayList<Long> blocksToBreak = new ArrayList<Long>();
	
	long[] allBlocks = null;
	
	boolean blocksUpToDate = false;
	
	public long[] getAllBlocks(){
		if(!blocksUpToDate || allBlocks == null){
			blocksUpToDate = true;
			allBlocks = ArrayUtils.toPrimitive(blocksToBreak.toArray(new Long[blocksToBreak.size()]));
		}
		return allBlocks;
	}

	public boolean addBlockToBreak(long merged){
		if(!blocksToBreak.contains(merged)){
			blocksUpToDate = false;
			blocksToBreak.add(merged);
			return true;
		}
		return false;
	}

	public boolean removeBlockToBreak(long merged){
		if(blocksToBreak.contains(merged)){
			blocksUpToDate = false;
			blocksToBreak.remove(merged);
			return true;
		}
		return false;
	}
	
	public void addBlocksToBreak(long... merged){
		if(merged == null) return;
		for(int a = 0; a < merged.length; a++){
			if(!blocksToBreak.contains(merged[a])){
				blocksUpToDate = false;
				blocksToBreak.add(merged[a]);
			}
		}
	}

	public void removeBlocksToBreak(long... merged){
		if(merged == null) return;
		for(int a = 0; a < merged.length; a++){
			if(blocksToBreak.contains(merged[a])){
				blocksUpToDate = false;
				blocksToBreak.remove(merged[a]);
			}
		}
	}
	
	public boolean canBreakBlock(int id, int meta){
		return blocksToBreak.contains(merge(id, meta));
	}
	
	public boolean canBreakBlock(long merged){
		return blocksToBreak.contains(merged);
	}


	public void clearSelectedBlocks() {
		blocksUpToDate = false;
		blocksToBreak.clear();
	}
	
	
	
	
	
	
	public CloneOption fight;
	public CloneOption sprint;
	public CloneOption follow;
	public CloneOption pickUp;
	public CloneOption walkToItems;
	public CloneOption retaliate;
	public CloneOption guard;
	public CloneOption wander;
	public CloneOption jump;
	public CloneOption curious;
	public CloneOption breakExtraBlocks;
	public CloneOption stats;
	public CloneOption female;
	public CloneOption breakBlocks;
	public CloneOption farming;
	
	EntityClone clone;
	
	public CloneOptions(EntityClone clone){
		this.clone = clone;
		addOption(fight = new CloneOption("Fight", 0, false, this));
		addOption(sprint = new CloneOption("Sprint", 1, false, this));
		addOption(follow = new CloneOption("Follow", 2, false, this));
		addOption(breakBlocks = new CloneOption("Break Blocks", 3, false, this));
		addOption(breakExtraBlocks = new CloneOption("Break Roughly", 4, false, this));
		addOption(pickUp = new CloneOption("Pick Up Items", 5, true, this));
		addOption(walkToItems = new CloneOption("Walk to items", 6, false, this));
		addOption(retaliate = new CloneOption("Retaliate", 7, false, this));
		addOption(guard = new CloneOption("Guard Position", 8, false, this));
		addOption(wander = new CloneOption("Wander", 9, false, this));
		addOption(jump = new CloneOption("Jump On Attack", 10, false, this));
		addOption(stats = new CloneOption("Stats", 11, true, this));
		addOption(female = new CloneOption("Female", 12, false, this));
		addOption(curious = new CloneOption("Curious", 13, true, this));
		addOption(farming = new CloneOption("Farming", 15, false, this));
	}
	
	private void addOption(CloneOption option){
		idToOption.put(option.id, option);
		options.add(option);
	}
	
	public void load(NBTTagCompound nbt){
		loadPublicData(nbt);
		loadPrivateData(nbt);
	}
	
	public void loadPublicData(NBTTagCompound nbt){
		NBTTagCompound optionsTag = nbt.getCompoundTag("CloneOptions");
		int[] ids = optionsTag.getIntArray("Ids");
		byte[] values = optionsTag.getByteArray("Values");
		if(ids != null && ids.length > 0 && values != null && values.length > 0 && ids.length == values.length){
			for(int a = 0; a < ids.length; a++){
				int id = ids[a];
				boolean value = (values[a] & 1) == 1;
				CloneOption option = idToOption.get(id);
				if(option != null){
					option.set(value);
				}
			}
		}else{
			Logger.log("CloneOptions int-byte arrays are invalid!");
		}
	}
	
	public void loadPrivateData(NBTTagCompound nbt){
		int[] idsAndMetas = nbt.getIntArray("Blocks");
		if(idsAndMetas != null && idsAndMetas.length % 2 == 0){
			for(int a = 0; a < idsAndMetas.length/2; a++){
				blocksToBreak.add(merge(idsAndMetas[a*2], idsAndMetas[a*2+1]));
			}
		}
		clearEntitiesToAttack();
		int[] entityIds = nbt.getIntArray("Entities");
		for(int a = 0; a < entityIds.length; a++){
			entitiesToAttack.add(entityIds[a]);
		}
	}
	
	public void save(NBTTagCompound nbt){
		savePublicData(nbt);
		savePrivateData(nbt);
	}
	
	public void savePublicData(NBTTagCompound nbt){
		NBTTagCompound optionsTag = new NBTTagCompound();
		int[] ids = new int[options.size()];
		byte[] values = new byte[options.size()];
		for(int a = 0; a < options.size(); a++){
			ids[a] = options.get(a).id;
			values[a] = (byte)(options.get(a).value?1:0);
		}
		
		
		optionsTag.setIntArray("Ids", ids);
		optionsTag.setByteArray("Values", values);
		nbt.setCompoundTag("CloneOptions", optionsTag);
	}
	
	public void savePrivateData(NBTTagCompound nbt){
		int[] idsAndMetas = new int[blocksToBreak.size()*2];
		for(int a = 0; a < blocksToBreak.size(); a++){
			idsAndMetas[a*2] = getId(blocksToBreak.get(a));
			idsAndMetas[a*2+1] = getMeta(blocksToBreak.get(a));
		}
		nbt.setIntArray("Blocks", idsAndMetas);
		nbt.setIntArray("Entities", getAllEntities());
	}
	
	public static long merge(int id, int meta){
		long value = id;
		value |= ((long)meta) << 32;
		return value;
	}
	
	public static int getMeta(long merged){
		return (int)((merged >> 32) & 0xffffffff);
	}
	
	public static int getId(long merged){
		return (int)(merged & 0xffffffff);
	}
	
	public boolean setOption(int optionID, boolean value){
		if(hasOption(optionID)){
			CloneOption option = getOption(optionID);
			if(option != null){
				option.set(value);
				return true;
			}
		}
		return false;
	}
	
	public CloneOption getOption(int id){
		return idToOption.get(id);
	}
	
	public int optionsSize(){
		return options.size();
	}
	
	public CloneOption getOptionByIndex(int index){
		if(index > -1 && index < options.size()){
			return options.get(index);
		}
		return null;
	}
	
	public boolean hasOption(int id){
		return idToOption.containsKey(id);
	}
	
	public void updateOptionTo(int optionID, EntityPlayer... players){
		if(hasOption(optionID)){
			getOption(optionID).updateOptionToAllPlayers(players);
		}
	}

	public void updateOptionToWatchingPlayers(int optionID) {
		if(hasOption(optionID)){
			getOption(optionID).updateOptionToAllWatching();
		}
	}

	private static HashMap classToIDMapping;
	
	static{
		classToIDMapping = (HashMap)Reflect.getStaticMapByKeyObjType(EntityList.class, Class.class, Integer.class, "classToIDMapping");
	}

	






}
